## Quick Start

After cloning the project, please:

1.) Install docker on your host machine by

```bash
sudo apt install docker.io
sudo apt-get install -y nvidia-docker2
sudo apt-get install nvidia-container-runtime
```

2.) Pull the base image

```bash
docker pull pytorch/pytorch:2.3.1-cuda12.1-cudnn8-devel
```

3.) Restart the docker service

```bash
sudo systemctl restart docker
```

4.) Go to your current project folder, and build the docker image:

```bash
docker build --build-arg USER_ID=$(id -u) --build-arg GROUP_ID=$(id -g) -t ours_py10:latest .
```

5.) Run the docker image by:

```bash
docker run --runtime=nvidia -it -p 12345:8888 -v /home/docker_share:/home/ -v $(pwd):/workspace ours_py10:latest /bin/bash
```

6.) Test the pretrained models using `python test.py`

7.) Visualize the results generated by the pretrained models using `python visualize.py`

Note: if you face the problem of "Failed to initialize NVML: Unknown Error" inside the container you can refer to [this thread](https://stackoverflow.com/questions/72932940/failed-to-initialize-nvml-unknown-error-in-docker-after-few-hours).

## Components

1.) `baselines`: Common tools.  

2.) `crowd_nav`: Configurations for new training and policy behaviors.  

3.) `crowd_sim`: Environments for CrowdNav, implemented hierarchically:  
    `CrowdSim` → `CrowdSimVarNum` → `CrowdSimPred` → `CrowdSimPredRealGST`.  
    Includes different agent implementations.  

4.) `dt_aci`: Python implementations of DtACI.  

5.) `gst_updated`: Learning-based prediction model GST.  

6.) `Python-RVO2`: ORCA package for collision avoidance.  

7.) `rl`: Networks and algorithms for PPO/PPO Lagrangian.  

8.) `trained_models`: Pretrained models.